<?php 
/*
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	OpenExchangeRates.php Version 0.2
	Copyright 2011, Anastis Sourgoutsidis, http://www.anastis.gr
*/

	class ExRates{
		private $provider;
		private $providers = array("OpenExchangeRates", "GoogleRates");
		private $obj;
		
		function __construct($provider="OpenExchangeRates")
		{
			if (in_array($provider, $this->providers))
			{
				$this->obj = new $provider();
			}
			else
			{
				throw new Exception('Undefined Exchange Rates Provider');
			}
		}
		
		public function getRates(){ return $this->obj->getRates(); }
		public function getBase(){ return $this->obj->getBase(); }
		public function getRate($currency="USD"){ return $this->obj->getRate($currency); }
		public function change($amount, $from, $to)	{ return $this->obj->change($amount, $from, $to); }
		
	}

	class OpenExchangeRates{
		private $rates_url = "http://openexchangerates.org/latest.php";
		private $base; // The base currency.
		private $rates = array(); // They array of currency rates, relative to the base.
		
		public function __construct()
		{
			$contents = @file_get_contents($this->rates_url);
			$json = json_decode($contents, true);
			$this->rates = $json['rates'];
			$this->base = $json['base'];
		}
		
		public function getRates(){ return $this->rates; }
		public function getBase(){ return $this->base; }
		
		public function getRate($currency="USD")
		{
			if( isset( $this->rates[$currency] ) )
			{
				return $this->rates[$currency];
			}
			return FALSE;
		}
		
		public function change($amount, $from, $to)
		{
			$base = $this->rates[$this->base]; // This should always be 1
			$from = $this->getRate($from);
			$to = $this->getRate($to);
			if ( ($from !== FALSE) and ($to !== FALSE) )
			{
				return $base / $from * $amount * $to;
			}
			return FALSE;
		}
	}
	
	class GoogleRates{
		private $rates_url = "http://www.google.com/ig/calculator?hl=en&q=%d%s=?%s";
		private $base = "USD"; // The base currency.
		private $rates = array(); // They array of currency rates, relative to the base.

		public function __construct()
		{
			$this->rates["USD"] = 1;
		}

		public function getRates(){ return $this->rates; }
		public function getBase(){ return $this->base; }
		
		public function getRate($currency="USD")
		{
			if( isset( $this->rates[$currency] ) )
			{
				return $this->rates[$currency];
			}
			
			$request = sprintf($this->rates_url, 1, $this->base, $currency);
			$contents = @file_get_contents($request);
			// The respons is not valid JSON (probably YAML), so let's enclose the names in double quotes to make it valid.
			// This is not future-proof, but it works without any other libraries and without messy regexes.
			$occurence_count = 1;
			$contents = str_replace('lhs', '"lhs"', $contents, $occurence_count);
			$contents = str_replace('rhs', '"rhs"', $contents, $occurence_count);
			$contents = str_replace('error', '"error"', $contents, $occurence_count);
			$contents = str_replace('icc', '"icc"', $contents, $occurence_count);
			$json = json_decode($contents, true);
			
			if (empty($json['error']))
			{
				$rhs = $json['rhs'];
				$result = (float)$rhs;
				if ($result > 0)
				{
					$this->rates[$currency] = $result;
					return $result;
				}
				else
				{
					return FALSE;
				}
			}
			
		}

		public function change($amount, $from, $to)
		{
			$base = $this->rates[$this->base]; // This should always be 1
			$from = $this->getRate($from);
			$to = $this->getRate($to);
			if ( ($from !== FALSE) and ($to !== FALSE) )
			{
				return $base / $from * $amount * $to;
			}
			return FALSE;
		}

	}
?>